/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.single;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Maybe;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.MaybeObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Notification;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Single;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Function;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;

public final class SingleDematerialize<T, R>
extends Maybe<R> {
    final Single<T> source;
    final Function<? super T, Notification<R>> selector;

    public SingleDematerialize(Single<T> source, Function<? super T, Notification<R>> selector) {
        this.source = source;
        this.selector = selector;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new DematerializeObserver<T, R>(observer, this.selector));
    }

    static final class DematerializeObserver<T, R>
    implements SingleObserver<T>,
    Disposable {
        final MaybeObserver<? super R> downstream;
        final Function<? super T, Notification<R>> selector;
        Disposable upstream;

        DematerializeObserver(MaybeObserver<? super R> downstream, Function<? super T, Notification<R>> selector) {
            this.downstream = downstream;
            this.selector = selector;
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T t) {
            Notification<R> notification;
            try {
                notification = Objects.requireNonNull(this.selector.apply(t), "The selector returned a null Notification");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            if (notification.isOnNext()) {
                this.downstream.onSuccess(notification.getValue());
            } else if (notification.isOnComplete()) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(notification.getError());
            }
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }
}

